﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PatientImageDetails.aspx.cs" Inherits="PatientImageDetails" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="ContentMain" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManagerMain" runat="server" ScriptMode="Release"></asp:ScriptManager>

    <script type ="text/javascript">

        $(document).ready(function () {

            var imageTypeSelection = $('#<%=RadComboBoxImageType.ClientID %>').val();
            if (imageTypeSelection == 'Other') {
                $('#<%=RadTextBoxOtherImageType.ClientID%>').prop('disabled', false);
            }

            var imageReasonSelection = $('#<%=RadComboBoxImagingReason.ClientID %>').val();
            if (imageReasonSelection == 'Other Symptom r/t Fragment (specify)') {
                $('#<%=RadTextBoxOtherImageReason.ClientID%>').prop('disabled', false);
            }

        }); // $(document).ready(function ()

        function RadComboBoxImageTypeOnClientLoad(sender) {

            var item = sender.get_selectedItem();
            if (item) {
                var text = item.get_text();

                if (text.indexOf('Other') !== -1) {
                $('#<%=RadTextBoxOtherImageType.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=RadTextBoxOtherImageType.ClientID%>').prop('disabled', true);
                    $('#<%=RadTextBoxOtherImageType.ClientID%>').val('');
                }
            } 
        }

        function RadComboBoxImageTypeOnClientSelectedIndexChanged(sender, args) {

            var text = args.get_item().get_text();

            if (text.indexOf('Other') !== -1) {
                $('#<%=RadTextBoxOtherImageType.ClientID%>').prop('disabled', false);
            } else {
                $('#<%=RadTextBoxOtherImageType.ClientID%>').prop('disabled', true);
                $('#<%=RadTextBoxOtherImageType.ClientID%>').val('');
            }
        }

        function RadComboBoxImagingReasonOnClientLoad(sender) {

            handleImagingReasonOther(sender);
        }

        function RadComboBoxImagingReasonOnClientItemChecked(sender, args) {

            var combo = $find("<%= RadComboBoxImagingReason.ClientID %>");

            handleImagingReasonOther(combo);
        }

        var handleImagingReasonOther = function (combo) {

            var otherReasonIndex = 5;

            var items = combo.get_items();

            var index = 0;

            items.forEach(function (item) {

                if (index++ == otherReasonIndex) {

                    if (item.get_checked()) {
                        $('#<%=RadTextBoxOtherImageReason.ClientID%>').prop('disabled', false);
                    } else {
                        $('#<%=RadTextBoxOtherImageReason.ClientID%>').prop('disabled', true);
                        $('#<%=RadTextBoxOtherImageReason.ClientID%>').val('');
                    }
                }
            });
        }

        function handleMultiSelectKeyPress(sender, eventArgs) {
            var space = 32;
            var key = eventArgs.get_domEvent().keyCode;

            var hi = sender.get_highlightedItem();
            if (hi && key === space) {
                var checked = hi.get_checked();
                if (!checked) {
                    hi.set_checked(true);
                } else {
                    hi.set_checked(false);
                }
            }
        }


    </script>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="Patients > Patient Lookup > Imaging > Image Details > " />
    </div> 

    <!-- ********************************************************************************************** -->
    <!-- PATIENT INFORMATION -->
    <div>
        <fieldset runat="server" ID="LatePanel">
            <h3 class="underline">Patient Information</h3>

            <!-- Patient Mame -->
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforLabelPatientName" 
                runat="server" 
                AssociatedControlID="LabelPatientName" 
                ToolTip="Patient Name" >
                Patient Name:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelPatientName" 
                runat="server" 
                ToolTip="Patient Name" >
            </asp:Label>
            <br />

            <!-- Patient SSN -->
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforLabelPatientSnum" 
                runat="server" 
                AssociatedControlID="LabelPatientSnum" 
                ToolTip="Patient SSN" >
                SSN:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelPatientSnum" 
                runat="server" 
                ToolTip="Patient SSN" >
            </asp:Label>
            <br />

            <!-- System Identified Possible Fragment -->
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforSystemIDFragment" 
                runat="server" 
                AssociatedControlID="LabelSystemIDFragment" 
                ToolTip="System Identified Possible Fragment" >
                System Identified Possible Fragment:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelSystemIDFragment" 
                runat="server" 
                ToolTip="System identified possible fragment" >
            </asp:Label>
            <br />

            <!-- Study Description -->
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforStudyDescription" 
                runat="server" 
                AssociatedControlID="LabelStudyDescription" 
                ToolTip="Study Description" >
                Study Description:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelStudyDescription" 
                runat="server" 
                ToolTip="System identified possible fragment" >
            </asp:Label>
            <br />
        </fieldset>
    </div>
   <br />

    <!-- ********************************************************************************************** -->
    <!-- IMAGE DATA -->
    <div>
        <fieldset runat="server" ID="Fieldset1">
            <h3 class="underline">Image Details</h3>

            <table align= "left" class="style1" cellpadding = "5" cellspacing = "5" border="0">

                <!-- Image Type -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelImageTpe" 
                            Text="Image Type:" 
                            AssociatedControlID="RadComboBoxImageType">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxImageType" 
                            runat="server"
                            EmptyMessage="(Select a Value)"
                            OnClientLoad="RadComboBoxImageTypeOnClientLoad"
                            OnClientSelectedIndexChanged="RadComboBoxImageTypeOnClientSelectedIndexChanged" > 
                        </telerik:radcombobox> 
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="Label9" 
                            Text="Other:"
                            AssociatedControlID="RadTextBoxOtherImageType">
                        </asp:Label>
                        <telerik:RadTextBox
                            ID="RadTextBoxOtherImageType" 
                            runat="server" 
                            Width="560px" >
                        </telerik:RadTextBox>
                    </td>
                </tr>

                <!-- Body Part Imaged -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelBodyPartImaged" 
                            Text="Body Part Imaged:" 
                            AssociatedControlID="RadComboBoxBodyPartImaged">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxBodyPartImaged" 
                            runat="server"
                            EmptyMessage="(Select a Value)"
                            CheckBoxes="true"
                            OnClientKeyPressing="handleMultiSelectKeyPress"
                            AllowMultipleSelection="true"> 
                        </telerik:radcombobox>     
                    </td>
                </tr>

                <!-- Reason(s) For Imaging -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelImagingReason" 
                            Text="Reason(s) For Imaging:"
                            AssociatedControlID="RadComboBoxImagingReason">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxImagingReason" 
                            runat="server"
                            EmptyMessage="(Select a Value)"
                            CheckBoxes="true"
                            AllowMultipleSelection="true"
                            OnClientKeyPressing="handleMultiSelectKeyPress"
                            OnClientLoad="RadComboBoxImagingReasonOnClientLoad"
                            OnClientItemChecked ="RadComboBoxImagingReasonOnClientItemChecked"> 
                        </telerik:radcombobox>
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelOtherImageReason" 
                            Text="Other:"
                            AssociatedControlID="RadTextBoxOtherImageReason">
                        </asp:Label>
                        <telerik:RadTextBox
                            ID="RadTextBoxOtherImageReason" 
                            runat="server" 
                            Width="560px">
                        </telerik:RadTextBox>
                    </td>
                </tr>

                <!-- Was a fragment documented -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelFragmentVerified" 
                            Text="Fragment Verified:" 
                            AssociatedControlID="RadComboBoxFragmentVerified">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxFragmentVerified" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>      
                    </td>
                </tr>

                <!-- Number of fragments -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelNumberOfFragments" 
                            Text="Number of Fragments:" 
                            AssociatedControlID="RadComboBoxNumberOfFragments">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxNumberOfFragments" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>      
                    </td>
                </tr>

                <!-- Include in report -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelIncludeInReport" 
                            Text="Include in Report:" 
                            AssociatedControlID="RadComboBoxIncludeInReport">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxIncludeInReport" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>      
                    </td>
                </tr>

                <!-- Largest Fragment Size -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelLargestFragmentSize" 
                            Text="Approx Size of Largest Fragment (length X width in mm) :" 
                            AssociatedControlID="RadTextBoxLargestFragmentSize">
                        </asp:Label>
                        <telerik:RadTextBox
                            ID="RadTextBoxLargestFragmentSize" 
                            runat="server">
                        </telerik:RadTextBox>  
                    </td>
                </tr>

                <!-- Smallest Fragment Size -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelSmallestFragmentSize" 
                            Text="Approx Size of Smallest Fragment (length X width in mm) :" 
                            AssociatedControlID="RadTextBoxSmallestFragmentSize">
                        </asp:Label>
                        <telerik:RadTextBox
                            ID="RadTextBoxSmallestFragmentSize" 
                            runat="server">
                        </telerik:RadTextBox>  
                    </td>
                </tr>

                <!-- Reviewed -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelReviewed" 
                            Text="Reviewed:" 
                            AssociatedControlID="RadComboBoxReviewed">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxReviewed" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>      
                    </td>
                </tr>

                <!-- Comments -->
                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelComments" 
                            Text="Comments:" 
                            AssociatedControlID="RadTextBoxImageComments">
                        </asp:Label>
                        <telerik:RadTextBox  
                            RenderMode="Lightweight" 
                            Height="119px" 
                            Width="1007px" 
                            EmptyMessage="Enter comments"
                            ID="RadTextBoxImageComments" 
                            runat="server" 
                            TextMode="MultiLine">
                        </telerik:RadTextBox>
                    </td>
                </tr>
            
            </table>
        </fieldset>
    </div>
   <br />
   
    <!-- ********************************************************************************************** -->
    <!-- Buttons -->
    <!-- ******* -->
    <table width="100%">
        <tr>
            <td align="left">
                <asp:Button 
                    runat = "server" 
                    ID = "BackButton" 
                    Text = "Back" 
                    Width = "130px" 
                    UseSubmitBehavior = "true" 
                    CausesValidation="false"
                    ToolTip="Return to previous page."/>
                <asp:Button 
                    runat = "server" 
                    ID = "SaveButton" 
                    Text = "Save" 
                    Width = "130px" 
                    OnClick = "SaveButton_Click" 
                    UseSubmitBehavior = "true" 
                    ToolTip="" />
            </td>
        </tr>
    </table> 
    <br />
    <br />

</asp:Content>


